// 
// \[X𐮗
// 
//

#include "stdinc.h"
#include "syscall.h"
#include "pg.h"
#include "pce.h"
#include "string.h"
#include "main.h"
#include "sound.h"
#include "filer.h"

#include "hue_fio.h"

#include "hue_joy.h"
#include "hue_image.h"

EmuRuntime eRun = {
    0,
    {0,0,0,0,0,0}
};

int exit_flag = 0;

void psp_ExitSet(void)
{
    exit_flag = 1;
}

//--------------------------------------------------------------------------
// callback function
//--------------------------------------------------------------------------
int psp_ExitCheck(void)
{
    return exit_flag;
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
static int exitcallback(void)
{
    exit_flag=1;
    return 0;
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
static void powercallback(void)
{
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
static  int callbackthread(void *arg) 
{
	int cbid = sceKernelCreateCallback("Exit Callback", exitcallback);
	sceExitSetCallback(cbid);
	cbid = sceKernelCreateCallback("Power Callback", powercallback);
    scePowerRegisterCallback(0, cbid);
    KernelPollCallbacks();
	return 0;
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
int setupcallbacks(void)
{
	int thid = 0;
    if ( ( thid = sceKernelCreateThread("Update Thread", (pg_threadfunc_t)callbackthread, 0x11, 0xFA0, 0, 0) ) < 0 ) {
        return thid;
    }
    sceKernelStartThread(thid, 0, 0);
	return thid;
}


//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
static int setup(void)
{
    // initialize
    pgInit();
    pgScreenFrame(2,0);
    
    // callback setup
    setupcallbacks();
    
#ifdef SOUND
    wavoutInit();
#endif
    
    InitImage();        // hue_image
    CLS(0);

    /* Ƃ肠ftHgݒɂĂ */
    _memcpy(&pConf,&eConf,sizeof(EmuConfig));
    
    return 1;
}

//--------------------------------------------------------------------------
//
//--------------------------------------------------------------------------
static int clean(void)
{
#ifdef SOUND
    wavoutClose();
#endif//SOUND
    
    if(pgPSP())
      scePowerSetClockFrequency(222,222,111);

    sceKernelExitGame();
    return 1;
}

//--------------------------------------------------------------------------
// main routine
//--------------------------------------------------------------------------
int xmain(int argc,char *argv)
{
    static char path[MAX_PATH];
    int ext[3]={EXT_PCE,EXT_ZIP,EXT_NULL};
    
    pgMain(argc,argv);
    setup();
    
    /* config file name */
    _strcpy(eRun.hue_path,pguGetWorkdir());
    
    if(LoadConfig()) pgPrint(0,0,RGB_BLUE,"Load Config file OK");
    else             pgPrint(0,0,RGB_RED ,"Load Config file NG");

    pgPrint(0,1,-1,eRun.hue_path);
    pgScreenFlipV();
    pgWaitVn(50);

    while(!exit_flag){
#ifndef WIN32
        if(getFilePath(path,eRun.hue_path,ext)==1) {
#else
        {
            _strcpy(path,"ms0:/Operation Wolf (J).pce");
#endif
            if(InitPCE(path,0)) {
                CLS(0);
                changeClock();
                image_config_update();
#ifdef SOUND
                initSound();
                enable_sound(eConf.sound);
#endif
                ClearImage();
                RunPCE();
#ifdef SOUND
                enable_sound(0);
                closeSound();
#endif
                clockDown();
            }
            CLS(0);
        }
    }
    
    // IƂɃf[^ۑ
    SaveConfig();
    
    clean();
    
    return 0;
}






